# Advanced Mini Whiteboard (Django)

## Quick start (development)
1. Create and activate a virtual environment:
   - `python -m venv venv`
   - `source venv/bin/activate` (Linux/macOS) or `venv\Scripts\activate` (Windows)

2. Install requirements:
   - `pip install -r requirements.txt`

3. (Optional but recommended) If you want full production-like websocket support, install and run Redis and update CHANNEL_LAYERS in settings.py:
   ```
   CHANNEL_LAYERS = {
     "default": {
       "BACKEND": "channels_redis.core.RedisChannelLayer",
       "CONFIG": {"hosts": [("127.0.0.1", 6379)]},
     },
   }
   ```

4. Run migrations:
   - `python manage.py migrate`

5. Create superuser (optional):
   - `python manage.py createsuperuser`

6. Run development server (ASGI):
   - `python manage.py runserver`

7. Open:
   - `http://127.0.0.1:8000/` to open the whiteboard.
   - `http://127.0.0.1:8000/gallery/` to view saved drawings.

## Notes
- The project uses an in-memory channel layer by default for simple development (no Redis required).
- Saved drawings are stored under `/media/drawings/`.
